spool refresh_station_char.log
set serveroutput on;

alter table station_char
modify ORGANIZATION_ID  VARCHAR2(256);

alter table station_char
modify STATION_ID  VARCHAR2(256);

alter table station_char
modify STATION_NAME     VARCHAR2(256);

alter table station_char
modify SEARCH_NAME    VARCHAR2(256 CHAR);

alter table station_char
modify DISPLAY_NAME  VARCHAR2(256 CHAR);



create or replace PROCEDURE SP_REFRESH_STATION_CHAR_new (in_nbr IN NUMBER,status	OUT	varchar2) AS
/***********************************************************************
Procedure		:  SP_REFRESH_STATION_CHAR
Release 		:
SIR				:
Description		:  Characteristic station association/summary table.
Author			:  Sree Rayankula
Created Date	:  01/31/2007
Updates:  01/31/2007 Edited to ignore drop index failures and included filters fk_char is not null and fk_station is not null -GT.
Comments		:
***********************************************************************/

   -- biological data cursor
   cursor biological_cur is
	select fk_char, fk_station as fk_fa_station,
	   generated_huc as hydrologic_unit_code, organization_id,
	   station_id, station_name,
	   count(*) as biological_count,
	   min(activity_start_date_time) as act_min_start_date,
	   max(activity_start_date_time) as act_max_start_date,
	   case when max(activity_stop_date_time) > max(activity_start_date_time)
	   then max(activity_stop_date_time) else max(activity_start_date_time)
	   end as act_max_start_stop_date
	from fa_biological_result
	where fk_char is not null
     	and fk_station is not null
	group by fk_char, fk_station, generated_huc,
		  organization_id, station_id, station_name;

   -- habitat data cursor
	cursor habitat_cur is
	select fk_char, fk_station as fk_fa_station,
	   generated_huc as hydrologic_unit_code, organization_id,
	   station_id, station_name,
	   count(*) as habitat_count,
	   min(activity_start_date_time) as act_min_start_date,
	   max(activity_start_date_time) as act_max_start_date,
	   case when max(activity_stop_date_time) > max(activity_start_date_time)
	   then max(activity_stop_date_time) else max(activity_start_date_time)
	   end as act_max_start_stop_date
	from fa_habitat_result
	where fk_char is not null
     	and fk_station is not null
	group by fk_char, fk_station, generated_huc,
		  organization_id, station_id, station_name;

	v_fk_char			   		number(12);
	v_fk_fa_station		   		number(12);
	v_huc				   		char(8 char);
	v_org_id			   		varchar2(256 byte);
	v_station_id		   		char(15 char);
	v_station_name		   		varchar2(256 byte);
	v_display_name				varchar2(256 char);
	v_search_name				varchar2(256 char);
	v_char_type_code			char(1 Byte);
	v_regular_count				number;
	v_biological_count			number;
	v_habitat_count				number;
	v_act_min_start_date   		date;
	v_act_max_start_date   		date;
	v_act_max_start_stop_date	date;
	v_result_count				number;
	v_record_count		   		number;
	v_min_start_date			date;
	v_max_start_date			date;
	v_max_start_stop_date		date;
	v_commit_count				number;

begin
status := 'successful';


  begin
	insert into characteristic_chartype (fk_characteristic,fk_chartype)
	select c.pk_isn, mcc.fk_chartype
	from di_characteristic c,
                mt_char_chartype mcc
	where c.display_name = mcc.char_name
	and not exists (select 1 from characteristic_chartype cc
                 where cc.fk_characteristic=c.pk_isn
                   and cc.fk_chartype=mcc.fk_chartype);
	commit;
  exception when others then
    Null;
  end;

--truncate station_char and drop all indexes on station_char
execute immediate 'truncate table station_char';
  begin
    execute immediate 'drop index ICS_FK_CHAR';
  exception when others then
    Null;
  end;

  begin
    execute immediate 'drop index ICS_FK_FA_STATN';
  exception when others then
    Null;
  end;

  begin
    execute immediate 'drop index ICS_SEARCH_NAME';
  exception when others then
    Null;
  end;

  begin
    execute immediate 'drop index ICS_CHAR_TYPE_CODE';
  exception when others then
    Null;
  end;

  begin
    execute immediate 'drop index ICS_FK_CHAR_FK_FA_STATN';
  exception when others then
    Null;
  end;

--load fa_regular_data into station_char
dbms_output.put_line('processing regular results...');
insert into station_char
   (fk_char, fk_fa_statn,
 	  hydrologic_unit_code, organization_id, station_id,
	  station_name, display_name,
	  search_name, char_type_code, regular_count,
	  act_min_start_date, act_max_start_date,
	  act_max_start_stop_date, result_count)
	select fk_char, fk_station as fk_fa_station,
		   generated_huc as hydrologic_unit_code, organization_id,
		   station_id, station_name, ' ',
		   ' ', ' ',  count(*) as regular_count,
		   min(activity_start_date_time) as act_min_start_date,
		   max(activity_start_date_time) as act_max_start_date,
   		   case when max(activity_stop_date_time) > max(activity_start_date_time)
   		   then max(activity_stop_date_time) else max(activity_start_date_time)
   		   end as act_max_start_stop_date,
		   count(*) as result_count
	from fa_regular_result
	where fk_char is not null
     	and fk_station is not null
	group by fk_char, fk_station, generated_huc,
		  organization_id, station_id, station_name;
commit;

--index station_char on (fk_char, fk_fa_statn)
execute immediate
'CREATE INDEX ICS_FK_CHAR_FK_FA_STATN ON STATION_CHAR(FK_CHAR, FK_FA_STATN)
TABLESPACE storetindx
STORAGE (INITIAL 5M NEXT 5M)';

--process biological result data
dbms_output.put_line('processing biological results...');
v_commit_count := 0;
open biological_cur;
loop
	fetch biological_cur into v_fk_char, v_fk_fa_station,
	 	  v_huc, v_org_id, v_station_id,
		  v_station_name, v_result_count,
		  v_act_min_start_date, v_act_max_start_date,
		  v_act_max_start_stop_date;
	exit when biological_cur%NOTFOUND;
	 select count(*) into v_record_count
	 from station_char
	 where fk_char = v_fk_char
 	   and fk_fa_statn = v_fk_fa_station;

	 -- if the record is not found, insert
	 if (v_record_count <=0) then
	 	v_commit_count := v_commit_count + 1;
	 	insert into station_char
	 	(fk_char, fk_fa_statn,
	 	  hydrologic_unit_code, organization_id, station_id,
		  station_name,display_name, search_name, char_type_code,
		  biological_count,
		  act_min_start_date, act_max_start_date,
		  act_max_start_stop_date, result_count)
	 	values
	 	(v_fk_char, v_fk_fa_station,
	 	  v_huc, v_org_id, v_station_id,
		  v_station_name, ' ', ' ', ' ',
		  v_result_count,
		  v_act_min_start_date, v_act_max_start_date,
		  v_act_max_start_stop_date, v_result_count);

		if (v_commit_count=1000) then
		   v_commit_count := 0;
		   commit;
		end if;
	 else
	 	 -- get min_act_start_date, max_act_start_date, max_act_start_stop_date
		 --from station_char
		 v_commit_count := v_commit_count + 1;
		 select act_min_start_date, act_max_start_date,
		 		act_max_start_stop_date into
				v_min_start_date, v_max_start_date,
				v_max_start_stop_date
		 from station_char
		 where fk_char = v_fk_char
		 	   and fk_fa_statn = v_fk_fa_station;

		--set min_start_date
		case when ((v_min_start_date is null) and
			 	  	(v_act_min_start_date is not null))
			then v_min_start_date := v_act_min_start_date;
		when ((v_min_start_date is not null and
			 	  	v_act_min_start_date is not null) and
			(v_min_start_date > v_act_min_start_date))
			then v_min_start_date := v_act_min_start_date;
		else
			 v_min_start_date := v_min_start_date;
		end case;

		--set max_start_date
		case when ((v_max_start_date is null) and
			 	  	(v_act_max_start_date is not null))
			then v_max_start_date := v_act_max_start_date;
		when ((v_max_start_date is not null and
			 	  	v_act_max_start_date is not null) and
			(v_max_start_date > v_act_max_start_date))
			then v_max_start_date := v_act_max_start_date;
		else
			 v_max_start_date := v_max_start_date;
		end case;

		--set max_start_stop_date
		case when ((v_max_start_stop_date is null) and
			 	  	(v_act_max_start_stop_date is not null))
			then v_max_start_stop_date := v_act_max_start_stop_date;
		when ((v_max_start_stop_date is not null and
			 	  	v_act_max_start_stop_date is not null) and
			(v_max_start_stop_date > v_act_max_start_stop_date))
			then v_max_start_stop_date := v_act_max_start_stop_date;
		else
			 v_max_start_stop_date := v_max_start_stop_date;
		end case;

	 	update station_char
		set biological_count = v_result_count,
			result_count = nvl(result_count, 0) + v_result_count,
			act_min_start_date = v_min_start_date,
			act_max_start_date = v_max_start_date,
			act_max_start_stop_date = v_max_start_stop_date
		where fk_char = v_fk_char
		   and fk_fa_statn = v_fk_fa_station;

		if (v_commit_count=1000) then
		   v_commit_count := 0;
		   commit;
		end if;
	 end if;
end loop;
close biological_cur;
commit;

--process habitat result data
dbms_output.put_line('processing habitat results...');
v_commit_count := 0;
open habitat_cur;
loop
	fetch habitat_cur into v_fk_char, v_fk_fa_station,
	 	  v_huc, v_org_id, v_station_id,
		  v_station_name, v_result_count,
		  v_act_min_start_date, v_act_max_start_date,
		  v_act_max_start_stop_date;
	exit when habitat_cur%NOTFOUND;
	select count(*) into v_record_count
	from station_char
 	where fk_char = v_fk_char
		 and fk_fa_statn = v_fk_fa_station;

	--if the record is not found, insert
	if (v_record_count <=0) then
	   v_commit_count := v_commit_count + 1;
	   insert into station_char
   	   (fk_char, fk_fa_statn,
	   hydrologic_unit_code, organization_id, station_id,
	   station_name, display_name, search_name, char_type_code,
	   habitat_count,
	   act_min_start_date, act_max_start_date,
	   act_max_start_stop_date, result_count)
	   values
	   (v_fk_char, v_fk_fa_station,
	   v_huc, v_org_id, v_station_id,
	   v_station_name, ' ', ' ', ' ',
	   v_result_count,
	   v_act_min_start_date, v_act_max_start_date,
	   v_act_max_start_stop_date, v_result_count);

	   if (v_commit_count=1000) then
	   	  v_commit_count := 0;
		  commit;
	   end if;
	else
	 	 --get min_act_start_date, max_act_start_date, max_act_start_stop_date
		 --from station_char
		 v_commit_count := v_commit_count + 1;
		 select act_min_start_date, act_max_start_date,
		 		act_max_start_stop_date into
				v_min_start_date, v_max_start_date,
				v_max_start_stop_date
		 from station_char
		 where fk_char = v_fk_char
		 	   and fk_fa_statn = v_fk_fa_station;

		--set min_start_date
		case when ((v_min_start_date is null) and
			 	  	(v_act_min_start_date is not null))
			then v_min_start_date := v_act_min_start_date;
		when ((v_min_start_date is not null and
			 	  	v_act_min_start_date is not null) and
			(v_min_start_date > v_act_min_start_date))
			then v_min_start_date := v_act_min_start_date;
		else
			 v_min_start_date := v_min_start_date;
		end case;

		--set max_start_date
		case when ((v_max_start_date is null) and
			 	  	(v_act_max_start_date is not null))
			then v_max_start_date := v_act_max_start_date;
		when ((v_max_start_date is not null and
			 	  	v_act_max_start_date is not null) and
			(v_max_start_date > v_act_max_start_date))
			then v_max_start_date := v_act_max_start_date;
		else
			 v_max_start_date := v_max_start_date;
		end case;

		--set max_start_stop_date
		case when ((v_max_start_stop_date is null) and
			 	  	(v_act_max_start_stop_date is not null))
			then v_max_start_stop_date := v_act_max_start_stop_date;
		when ((v_max_start_stop_date is not null and
			 	  	v_act_max_start_stop_date is not null) and
			(v_max_start_stop_date > v_act_max_start_stop_date))
			then v_max_start_stop_date := v_act_max_start_stop_date;
		else
			 v_max_start_stop_date := v_max_start_stop_date;
		end case;

	 	update station_char
		set habitat_count = v_result_count,
			result_count = nvl(result_count, 0) + v_result_count,
			act_min_start_date = v_min_start_date,
			act_max_start_date = v_max_start_date,
			act_max_start_stop_date = v_max_start_stop_date
		where fk_char = v_fk_char
		   and fk_fa_statn = v_fk_fa_station;

		if (v_commit_count=1000) then
		   v_commit_count := 0;
		   commit;
		end if;
	end if;
end loop;
close habitat_cur;
commit;

execute immediate 'update station_char
	set char_type_code = (select type_code
					   	 from di_characteristic
						 where station_char.fk_char = di_characteristic.pk_isn),
		search_name = (select search_name
					  from di_characteristic
					  where station_char.fk_char = di_characteristic.pk_isn),
		display_name = (select display_name
					   from di_characteristic
					   where station_char.fk_char = di_characteristic.pk_isn)';
commit;


--create indexes on station_char
execute immediate
'CREATE INDEX ICS_FK_CHAR ON STATION_CHAR(FK_CHAR)
TABLESPACE storetindx
STORAGE (INITIAL 5M NEXT 5M)';

execute immediate
'CREATE INDEX ICS_FK_FA_STATN ON STATION_CHAR(FK_FA_STATN)
TABLESPACE storetindx
STORAGE (INITIAL 5M NEXT 5M)';

execute immediate
'CREATE INDEX ICS_SEARCH_NAME ON STATION_CHAR(SEARCH_NAME)
TABLESPACE storetindx
STORAGE (INITIAL 5M NEXT 5M)';

execute immediate
'CREATE INDEX ICS_CHAR_TYPE_CODE ON STATION_CHAR(CHAR_TYPE_CODE)
TABLESPACE storetindx
STORAGE (INITIAL 5M NEXT 5M)';



BEGIN
execute immediate 'ANALYZE TABLE STATION_CHAR COMPUTE STATISTICS  FOR TABLE FOR ALL INDEXES';
exception when OTHERS then
 NULL;
END;

--update fa_station
--update fa_station set station_visited = 'YES'
--where pk_isn in (select distinct(fk_fa_statn) from station_char);

update fa_station S set station_visited = 'YES'
WHERE EXISTS(SELECT 1 FROM STATION_CHAR SC
         WHERE SC.fk_fa_statn = S.PK_ISN);
commit;

exception when OTHERS then
status := 'failed';
dbms_output.put_line(sqlcode ||' ' ||sqlerrm);
end;
/
show errors;

--select count(*) from station_char;
/*
set serveroutput on size 60000;
declare
  IN_NBR NUMBER;
  STATUS VARCHAR2(200);
begin
  SP_REFRESH_STATION_CHAR_NEW(IN_NBR => IN_NBR,STATUS => STATUS);
end;
/

select count(*) from station_char;
*/
spool off;